<?php
/* --------------------------------------------------------------
   ParcelServiceProvidersId.inc.php 2020-02-28
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Model;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceId as ParcelServiceIdInterface;
use Webmozart\Assert\Assert;

/**
 * Class ParcelServiceId
 *
 * @package Gambio\Admin\ParcelService\Model
 */
class ParcelServiceId implements ParcelServiceIdInterface
{
    /**
     * @var int|null
     */
    private $value;
    
    
    /**
     * ParcelServiceId constructor.
     *
     * @param int|null $value
     */
    private function __construct(?int $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * @param int|null $value
     *
     * @return ParcelServiceId
     */
    public static function create(?int $value = null): ParcelServiceId
    {
        if ($value !== null) {
            Assert::greaterThan($value, 0, 'The parcel service id must be a positive integer. Got: %s');
        }
        
        return new self($value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): ?int
    {
        return $this->value;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize(): ?int
    {
        return $this->value();
    }
}